Graphics3D 800,600,32,2
SetBuffer BackBuffer()

MoveMouse GraphicsWidth()/2.8, GraphicsHeight()/2

HidePointer

player = CreatePivot()
Global camera=CreateCamera(player)
CameraClsColor camera, 0,162,232
CameraRange camera,0.1,10000

light=CreateLight()
RotateEntity light,90,0,0

cursor=LoadImage ("puntero1.png")

Global plane=CreatePlane()
grass_tex=LoadTexture( "textura_suelo_piedra.jpg" )
EntityTexture plane,grass_tex

Global cerdo=LoadAnimMesh("Asalto.b3d")
ScaleEntity cerdo,0.01,0.01,0.01
RotateEntity cerdo,0,180,0
cerdo_hijo=FindChild (cerdo, "Cylinder01")

;en vez de usar esta funcion de blizt, uso las mias
;ExtractAnimSeq( cerdo_hijo,1,10 ) 	;anim seq 1: frames 0...10 are 'parado'
;ExtractAnimSeq( cerdo_hijo,11,20 )	;anim seq 2: frames 11...21 are 'correr'
anim1.animar = crear_animacion (cerdo_hijo,2,1,10)
anim2.animar = crear_animacion (cerdo_hijo,1,11,20)
Global anim.animar

;ESTRUCTURA NECESARIA PARA ANIMAR POR FRAMES

Type animar
	Field modelo
	Field frame_inicio#
	Field frame_final#
	Field max_frames#
	Field frame_actual#
	Field vel#
	Field vel_nueva#
	Field factor_suavizar#
	Field reg_suavizar
	Field reg_bucle
	Field reg_inverso
End Type

;creo una estructura de objetos para poder crear disparos
Type disparo
	Field bala
	Field vel#
End Type

;estructura efecto
Type efecto
	Field sprite
	Field alpha#
End Type

cerdo_Spine1 = FindChild (cerdo, "Bip01 Spine1")
Global cerdo_arma = FindChild (cerdo, "jamon_asalto")

EntityParent cerdo_arma, cerdo_Spine1

;NUEVO CODIGO
;cualquier duda que tengas sobre el codigo preguntame


Global sprite = LoadSprite ("hyperflare.bmp")
HideEntity sprite
SpriteViewMode sprite,2
RotateEntity sprite,90,0,0
ScaleSprite sprite,0.1,0.1

Global piv_cerdo = CreatePivot()
EntityParent piv_cerdo,cerdo
PositionEntity piv_cerdo,0,0,0
MoveEntity piv_cerdo,0,120,-100
EntityParent camera,piv_cerdo,0
EntityParent camera,0
Global piv_cabeza = CreatePivot()
EntityParent piv_cabeza,cerdo,0
MoveEntity piv_cabeza,0,100,0

Global piv_arma = CreatePivot()
EntityParent piv_arma,cerdo_arma
RotateEntity piv_arma,0,0,0
PositionEntity piv_arma,500,0,0




;FIN DE NUEVO CODIGO



While Not KeyDown( 1 )
	

	If KeyDown( 32 )=True Then TurnEntity cerdo,0,-1,0
	If KeyDown( 30 )=True Then TurnEntity cerdo,0,1,0
	
	tecla_w = KeyDown(17)
	tecla_s = KeyDown(31)
	mouse_1 = MouseDown(1)
	
	If tecla_s = 1 Then 
		anim = anim2
		animar (anim,-0.2)
		MoveEntity cerdo,0,0,0.04
	EndIf
	
	If tecla_w = 1 Then
		anim = anim2
		animar (anim,0.2)
		MoveEntity cerdo,0,0,-0.04
	EndIf
	
	If tecla_s = 0 And tecla_w = 0 Then
		If anim <> anim1 Then
			anim = anim1
			anim\frame_actual# = anim\frame_inicio#
		EndIf
		anim = anim1
		animar (anim,0.020)
	EndIf
	
	actualizar_animacion (anim)
	
	;NUEVO CODIGO
	mov_mouse_x# = MouseXSpeed()
	mov_mouse_y# = MouseYSpeed()
	MoveMouse GraphicsWidth()/2,GraphicsHeight()/2
	mxs#=mxs# + mov_mouse_x#
	mys#=mys# + mov_mouse_y#

	;FIN DE NUEVO CODIGO
	
	;NUEVO CODIGO
	
	;mover camara suavizada
	factor# = 0.05
	cam_x# = (EntityX(piv_cerdo,1) - EntityX(camera,1)) * factor#
	cam_y# = (EntityY(piv_cerdo,1) - EntityY(camera,1)) * factor#
	cam_z# = (EntityZ(piv_cerdo,1) - EntityZ(camera,1)) * factor#
	PointEntity camera,piv_cabeza
	TranslateEntity camera,cam_x#,cam_y#,cam_z#
	
	;FIN DE NUEVO CODIGO
		
	If mxs# > 45 Then mxs# = 45
	If mxs# < -45 Then mxs# = -45
	
	If mys# > 30 Then mys# = 30
	If mys# < -30 Then mys# = -30
	
	RotateEntity cerdo_Spine1, mxs#, mys#,0

	
	
	
	RenderWorld
	UpdateWorld 
	
	;disparar
	If mouse_1 = 1 And Rand(3) = 1 Then
		crear_disparo ()
	EndIf
	actualizar_disparos()
	actualizar_efectos ()
	
	;NUEVO CODIGO PARA APUNTAR

	; se trata de crear un pivote (piv_arma) emparentado con el arma a una distancia que te venga bien, por ejemplo 500
	; ese pivote se movera al moverse el arma, luego solo tienes que proyectar las coordenadas de ese pivote a la pantalla 2d
	; eso lo haces con el comando cameraproject


	CameraProject camera,EntityX(piv_arma,1),EntityY(piv_arma,1),EntityZ(piv_arma,1)
	
	cursor_x# = ProjectedX()
	cursor_y# = ProjectedY()

	DrawImage cursor,cursor_x# - 10,cursor_y# - 20

	;FIN DE NUEVO CODIGO
	
	
	;DrawImage cursor,MouseX(),MouseY()

	Text 0,0,"Para mover y girar son W,A,S,D y el raton para apuntar o eso intento hacer"
	
	Flip
	
Wend

End
;~IDEal Editor Parameters:
;~C#Blitz3D



;FUNCIONES DE EFECTOS
;-----------------------------------------------------------------------------------------------------------
;Crear efecto
;-----------------------------------------------------------------------------------------------------------
Function crear_efecto (ente)
	a.efecto = New efecto
	a\sprite = CopyEntity (sprite)
	PositionEntity a\sprite,EntityX(ente,1),EntityY(ente,1)+0.05,EntityZ(ente,1),1
	a\alpha# = 1
End Function


;-----------------------------------------------------------------------------------------------------------
;Borrar efecto
;-----------------------------------------------------------------------------------------------------------
Function borrar_efecto (a.efecto)
	FreeEntity a\sprite
	Delete a

End Function


;-----------------------------------------------------------------------------------------------------------
;Actualizar efecto
;-----------------------------------------------------------------------------------------------------------
Function actualizar_efectos()
	For a.efecto = Each efecto
		a\alpha# = a\alpha# - 0.1
		EntityAlpha a\sprite,a\alpha#
		If a\alpha# <= 0 Then borrar_efecto (a)
	Next
End Function

;FUNCIONES DE DISPAROS

;-----------------------------------------------------------------------------------------------------------
;Crear disparo
;-----------------------------------------------------------------------------------------------------------
Function crear_disparo ()
	a.disparo = New disparo
	a\vel# = Rnd (0.2,0.45)
	a\bala = CreateSphere (4)
	EntityColor a\bala,0,0,0
	EntityAlpha a\bala,0.5
	ScaleEntity a\bala,0.02,0.02,0.1
	;una vez copiado el ente "sprite_arma" ai que colocarlo de forma que salga del caon
	PositionEntity piv_arma,40,0,0
	EntityParent a\bala,piv_arma
	PositionEntity a\bala,0,0,0
	EntityParent a\bala,0
	PositionEntity piv_arma,0,0,0
	PointEntity a\bala,piv_arma

	PositionEntity piv_arma,500,0,0
End Function

;-----------------------------------------------------------------------------------------------------------
;Borrar disparos
;-----------------------------------------------------------------------------------------------------------
Function borrar_disparo (a.disparo)
	;borro el ente bala (lo que ves en la pantalla como un disparo)
	FreeEntity a\bala
	;borro el objeto (lo que no ves, el objeto que se guarda en la memoria)
	Delete a
End Function

;-----------------------------------------------------------------------------------------------------------
;Actualizar disparos
;-----------------------------------------------------------------------------------------------------------
Function actualizar_disparos ()
	;recorro todos los objetos disparo y voy moviendo en "z" todas las balas
	For a.disparo = Each disparo
		reg_borrar = 0
		MoveEntity a\bala,0,0,-a\vel#
		If EntityY(a\bala,1) < EntityY(plane) Then crear_efecto (a\bala) : reg_borrar = 1
		;si la distancia de la camara a la bala es mayor a 1000 se borra el disparo
		If EntityDistance(camera,a\bala) > 1000 Then reg_borrar = 1
		If reg_borrar = 1 Then borrar_disparo (a)
	Next
End Function




;ESTAS FUNCIONES SON NECESARIAS PARA ANIMAR CONSERVANDO EL FRAME DE ANIMACION PARA PODER RECOJER CORRECTAMENTE LAS COORDENADAS X,Y,Z

;este modo de animacion lo que ace es animar manualmente, para poder pausar la animacion cuando se desee sin usar animate

;-----------------------------------------------------------------------------------------------------------
;Crear animacion para un ente
;-----------------------------------------------------------------------------------------------------------
Function crear_animacion.animar (ente,reg_bucle = 0,frame1 = 0,frame2 = 0)
	a.animar = New animar
	a\modelo = ente
	SetAnimTime a\modelo,0
	a\max_frames# = AnimLength(ente)
	a\frame_actual# = AnimTime (ente)
	a\vel# = 0
	a\reg_bucle = reg_bucle
	If frame1 = 0 And frame2 = 0 Then
		a\frame_inicio# = 0
		a\frame_final# = a\max_frames# - 1
	EndIf
	If frame1 <> 0 Or frame2 <> 0 Then
		a\frame_inicio# = frame1
		a\frame_final# = frame2
	EndIf
	
	Return a
End Function


;-----------------------------------------------------------------------------------------------------------
;Borrar animacion
;-----------------------------------------------------------------------------------------------------------
Function borrar_animacion (a.animar)
	If a <> Null Then Delete a
End Function

;-----------------------------------------------------------------------------------------------------------
;Anima una ente a una velocidad (vel#)
;-----------------------------------------------------------------------------------------------------------
Function animar (a.animar,vel#,reg_suavizar = 0,factor_suavizar# = 0.1)
	If a <> Null Then
		If reg_suavizar = 1 Then
			a\vel_nueva# = vel# * f_mov#
			a\factor_suavizar = factor_suavizar# * f_mov#
		EndIf
		a\reg_suavizar = reg_suavizar
		If reg_suavizar = 0 Then a\vel# = vel#
	EndIf
End Function

;-----------------------------------------------------------------------------------------------------------
;Actualiza la animacinon de un ente
;-----------------------------------------------------------------------------------------------------------
Function actualizar_animacion (a.animar)
	If a <> Null Then
		If a\reg_suavizar = 1 Then
			a\vel# = a\vel# - (a\vel# - a\vel_nueva#) * a\factor_suavizar#
			If a\vel# < 0.001 Then a\vel# = 0
		EndIf
		If a\reg_bucle = 0 Or a\reg_bucle = 1 Then a\frame_actual# = a\frame_actual# + a\vel#
		If a\reg_bucle = 0 Then
			If a\frame_actual# > a\frame_final# Then a\frame_actual# = a\frame_final#
			If a\frame_actual# < a\frame_inicio# Then a\frame_actual# = a\frame_inicio#
		EndIf
		If a\reg_bucle = 1 Then
			If a\frame_actual# > a\frame_final# Then a\frame_actual# = a\frame_inicio#
			If a\frame_actual# < a\frame_inicio# Then a\frame_actual# = a\frame_final# - 1
		EndIf
		If a\reg_bucle = 2 Then
			If a\frame_actual# > a\frame_final# Then a\frame_actual# = a\frame_final# : a\reg_inverso = 0
			If a\frame_actual# < a\frame_inicio# Then a\frame_actual# = a\frame_inicio# : a\reg_inverso = 1
			If a\reg_inverso = 1 Then a\frame_actual# = a\frame_actual# + a\vel#
			If a\reg_inverso = 0 Then a\frame_actual# = a\frame_actual# - a\vel#

		EndIf
		SetAnimTime a\modelo,a\frame_actual#
	EndIf
End Function

